<?php
 /**
  * @category Mageants Product360Image
  * @package Mageants_Product360Image
  * @copyright Copyright (c) 2017 Mageants
  * @author Mageants Team <support@Mageants.com>
  */
namespace Mageants\AlsoBought\ViewModel;

class ViewModelData implements \Magento\Framework\View\Element\Block\ArgumentInterface
{

    public const ALSOBOUGHT_PRODUCT_CART_BUTTON= 'alsobought_section/alsobought_product/alsobought_product_cart_button';
    public const ALSOBOUGHT_PRODUCT_TITLE = 'alsobought_section/alsobought_product/alsobought_product_title';
    public const ALSOBOUGHT_PRODUCT_LAYOUT = 'alsobought_section/alsobought_product/alsobought_product_layout';
    public const SLIDER_ITEMS = 'alsobought_section/slider_settings/slider_items';
    public const SLIDER_LOOP = 'alsobought_section/slider_settings/slider_loop';
    public const SLIDER_DOTS = 'alsobought_section/slider_settings/slider_dots';
    public const SLIDER_NAV = 'alsobought_section/slider_settings/slider_nav';
    public const ALSOBOUGHT_CART_CART_BUTTON = 'alsobought_section/alsobought_cart/alsobought_cart_cart_button';
    public const ALSOBOUGHT_CART_TITLE = 'alsobought_section/alsobought_cart/alsobought_cart_title';
    public const ALSOBOUGHT_CART_LAYOUT = 'alsobought_section/alsobought_cart/alsobought_cart_layout';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    protected $scopeConfig;

    /**
     * __construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * GetProductCartBtn
     *
     * @return mixed
     */
    public function getProductCartBtn()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_PRODUCT_CART_BUTTON,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetProductTitle
     *
     * @return mixed
     */
    public function getProductTitle()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_PRODUCT_TITLE,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetProductLayout
     *
     * @return mixed
     */
    public function getProductLayout()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_PRODUCT_LAYOUT,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetSliderItem
     *
     * @return mixed
     */
    public function getSliderItem()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_ITEMS,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetSliderLoop
     *
     * @return mixed
     */
    public function getSliderLoop()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_LOOP,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetSliderDots
     *
     * @return mixed
     */
    public function getSliderDots()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_DOTS,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetSliderNav
     *
     * @return mixed
     */
    public function getSliderNav()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_NAV,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

        /**
         * GetCartCartBtn
         *
         * @return mixed
         */
    public function getCartCartBtn()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_CART_CART_BUTTON,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetCartTitle
     *
     * @return mixed
     */
    public function getCartTitle()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_CART_TITLE,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * GetCartLayout
     *
     * @return mixed
     */
    public function getCartLayout()
    {
        return $this->scopeConfig->getValue(
            self::ALSOBOUGHT_CART_LAYOUT,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
}
